/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.block.CharmBlock;

public class GlowballBlobBlock
extends CharmBlock
implements IWaterLoggable {
    public static final Map<Direction, VoxelShape> SHAPE = new HashMap<Direction, VoxelShape>();
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public GlowballBlobBlock(CharmModule module) {
        super(module, "glowball_blob", AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200946_b().func_235838_a_(l -> 8));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE.get(state.func_177229_b((Property)FACING));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] directions;
        BlockState state = this.func_176223_P();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean isWaterlogged = fluidstate.func_206886_c() == Fluids.field_204546_a;
        for (Direction direction : directions = context.func_196009_e()) {
            Direction opposite = direction.func_176734_d();
            if (!(state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)opposite)).func_196955_c((IWorldReader)world, pos)) continue;
            return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return direction.func_176734_d() == state.func_177229_b((Property)FACING) && !state.func_196955_c((IWorldReader)world, pos) ? Blocks.field_150350_a.func_176223_P() : state;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockState = world.func_180495_p(blockPos);
        return blockState.func_224755_d((IBlockReader)world, blockPos, direction);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    @Override
    public BlockItem createBlockItem(ResourceLocation id) {
        return null;
    }

    @Override
    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    static {
        SHAPE.put(Direction.UP, Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0));
        SHAPE.put(Direction.DOWN, Block.func_208617_a((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        SHAPE.put(Direction.EAST, Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0));
        SHAPE.put(Direction.SOUTH, Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0));
        SHAPE.put(Direction.WEST, Block.func_208617_a((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        SHAPE.put(Direction.NORTH, Block.func_208617_a((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0));
    }
}

